library(multiSiena)
##test1
mData <- list()
for (i in 1:10){
	net <- sienaDependent(array(c(smallNetworks[[1]],smallNetworks[[4*i+1]]),
							dim=c(5,5,2)), allowOnly=FALSE)
	mData[[i]] <- sienaDataCreate(net)
}
(multiData <- sienaGroupCreate(mData))
# specify model
eff.p <- getEffects(multiData)
eff.p <- setEffect(eff.p, density, random=TRUE)
eff.p <- setEffect(eff.p, recip, random=TRUE)
eff.p <- setEffect(eff.p, transTrip, random=TRUE)
print(eff.p, includeRandoms=TRUE, dropRates=TRUE)
alg.ml <- sienaAlgorithmCreate(seed=123, prML=2)
Mu <- c(1,-1,0.5,0.2)
Sig <- matrix(0,4,4)
diag(Sig) <- 0.09
(bayes.model <- sienaBayes(alg.ml, data=multiData,
       effects=eff.p, nprewarm=2, nwarm=5, nmain=10, nrunMHBatches=5,
	   nImproveMH=2,
	   initgainGroupwise=0, reductionFactor=0.1,
	   priorMu=Mu, priorSigma=Sig, priorKappa=0.09,
	   silentstart=TRUE, saveFreq=0))
shortBayesResults(bayes.model)
##test2
(plotPostMeansMDS(bayes.model, method=1, excludeRates=FALSE)$points)
##test3
mbt <- multipleBayesTest(bayes.model, c(2,3))
print(mbt, descriptives=TRUE)
##test4
(simdat <- simulateData(1, bayes.model, multiData, seed=123))
simdat$sims[[10]]
## delete output file
if (file.exists('Siena.txt')){unlink('Siena.txt')}
